
markup.push({

// MARK: - system audio block

SystemAudioBlock:
{
	"+": "SourceTemplate",
	gxAllowTallTitle: true,
	gxTitle: "System-Wide Audio",
	gxPopoverTitle: "System-Wide Audio",
	geNodeClass: "GESystemAudioNode",
	geInputRank: 1,
	h4PresetsId: "SystemAudioPresets",
	gxLibraryDescription: "Capture all audio played on the system",
	gxIconPainter: "ImagePainter.block.system.audio",
	gxLibraryIcon: "library.system.audio",
	gxPopoverInfo: "SystemAudioPopover",
},


// MARK: - system audio popover

SystemAudioPopover:
{
	"+": "PopoverTemplate",
	gxTitle: "System-Wide Audio",
	gxLayout: [
		"H:|-12-[self(350)]-12-|",
		"V:|-12-[self]-12-|",
		"V:|-41-[group]-6-[presetsGroup]"
	],
	gxChildViews:
	{
		title: "PopoverTitle",
		switch: "PopoverOnOffSwitch",
		presetsGroup: presetsGroup(),
		group:
		{
			"+": "GroupView",
			gxLayout: [
				"H:|[self]|",

				"V:|-14-[text(28)]-14-[captureAlertSounds]-4-[text1]-11-[advancedBtn]-0-[advanced]-0-|",

				"H:|-15-[infoIcon(16)]-7-[text]-16-|",
				"V:|-16-[infoIcon(16)]",

				"H:|-12-[captureAlertSounds(160)]",
			],
			gxChildViews:
			{
				infoIcon: { "+": "InfoIcon" },
				text: {
					"+": "DescriptionLabelView",
					gxDefaultValue: "The System-Wide Audio source captures all audio produced by your Mac."
				},
				captureAlertSounds: {
					"+": "CheckboxTemplate",
					gxTitle: "<checkbox/> Include alert sounds",
					gxValueKey: "node.captureAlertSounds",
				},
				text1: {
					"+": "DescriptionLabelView",
					gxDefaultValue: "Sound effects are ordinarily not included in captured audio. Turn on this checkbox to capture these alert sounds as well.",
					gxLayout: [ "H:|-38-[text1]-15-|", "V:[self(44)]" ],
				},
				advancedBtn: {
                    "+": "AdvancedGroupButton",
                    gxTitle: "<disclosure/> Advanced",
					axFormatter: disclosureAxFormatter("Advanced"),
                    gxValueKey: "uiState.advancedExpanded"
                },
				advanced:
				{
					"+": "ExpandingGroupView.noTopStroke",
					gxValueKey: "uiState.advancedExpanded",
					gxCollapsible: true,
                    gxCollapsedSize: 1,
					gxExtraSize: 10,
					gxLayout: [
						"H:|-0-[self]-0-|",
						"V:|-4-[heading]-6-[excludedAppsView(158)]-9-[text2]",
						"H:|-15-[heading]",
					],
					gxChildViews:
					{
						heading: labelView("Excluded Sources:"),
						excludedAppsView: {
							nsClass: "GXDrawView",
							gxLayout: [
								"H:|-0-[self]-0-|",
								"H:|-14-[addExcludedSource(192)]-(>=10)-[deleteExcludedSource(24)]-14-|&alignBaseline",
								"V:|-0-[excludedAppsContents]-7-[addExcludedSource]-0-|",

								"H:|-0-[dropView]-0-|",
								"V:|-0-[dropView]-7-[addExcludedSource]",
							],
							gxChildViews:
							{
								dropView: {
									nsClass: "GXDropView",
									acceptDroppedApps: true,
									gxValueKey: "node.droppedApps",
									gxLayerZPosition: 10,
									gxHilitePainter: {
										"+": "DropHilitePainter",
										gxCornerRadius: 0,
									},
								},
								excludedAppsContents:
								{
									nsClass: "GXDrawView",
									axTitle: "Excluded Sources",
									axIsIgnored: true,
									gxLayout: [ "H:|[self]|",
												"V:[self]",
												"H:|[scrollView]|",
												"V:|[scrollView]|" ],
									gxChildViews:
									{
										scrollView: {
											nsClass: "GXScrollView",
											gxBackColor: "SidebarBackColor3",
											gxVScrollbar: "ScrollBarView",
											gxDocumentView: {
												nsClass: "GXListView",
												gxViewName: "excludedAppsListView",
												gxListItemView: "SystemAudioExcludedAppsListItem",
												axIsIgnored: false,
												axTitle: "Excluded Sources list",
												axHelp: "App sources in this list are not included in the captured audio",
 												gxValueKey: "node.excludedAppsList.subModels",
												gxCopyValues: true,
												gxItemHeight: 24,
												gxTopHeight: 8,
												gxInterItemHeight: 1,
												gxBottomHeight: 8,
												gxLayout: [ "H:|[self]|" ],
											},
										},
									},
								},
								divider1: dividerView(),
								addExcludedSource: {
									"+": "PlusButton",
									gxTitle: "<plusButton/> Exclude Source\u2002<menuIcon.foreColor2.app.pulldown.arrow/>", // \u2002 is 'en space'
									nsClass: "GEAppPopupView",
									axHelp: "Add a source to the Excluded source list",
									gxValueKey: "node.excludedApp",
								},
								deleteExcludedSource: {
									"+": "MinusButton",
									gxTitle: "<minusButton/>",
									axHelp: "Delete selected excluded source",
									gxValueKey: "node.deleteExcludedApp",
								},
							},
						},
						text2: {
							"+": "DescriptionLabelView",
							gxDefaultValue: "By default, System-Wide Audio captures all audio played by the system. To exclude specific applications, add them to this table.",
							gxLayout: [ "H:|-15-[self]-12-|", "V:[self(44)]" ],
						},
					}
				}
			}
		}
	}
},


// MARK: - system audio excluded apps model

SystemAudioExcludedAppModel:
{
	nsClass: "GESystemAudioExcludedApp",
},


// MARK: - system audio excluded apps list item

SystemAudioExcludedAppsListItem:
{
	nsClass: "GXListItemView",
	gxSelectable: 2, // multiselect
	gxBackPainter: {
		"+": "ListItemBack",
		gxEdgeInsets: "12, 0, 2, 0",
		gxFillColor: "",	// skip fill until selected
	},
	gxLateLayout:
	[
		"V:|-(-999)-[self(24)]",		// vertical position set by parent

		"H:|-2-[self]-2-|",
		"H:|-23-[icon(22)]-8-[title]-0-|",
		
		"V:|-1-[icon(22)]",
		"V:|-3-[title]",
	],
	gxChildViews:
	{
		icon: {
			nsClass: "GXDrawView",
			gxForePainter: "ImagePainter",
			gxValueKey: "icon",
		},
		title: {
			"+": "LabelView.mediumWeight.foreColor1.left.size13",
			axIsIgnored: false,
			axDescription: "Excluded source",
			gxValueKey: "title",
		},
	},
},

})
